/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.steps;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.IVWPropertyTab;
import filenet.vw.toolkit.design.property.steps.VWRoutingPanel;
import filenet.vw.toolkit.design.property.tables.VWStepResponseTableModel;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWFieldsCellEditor;
import filenet.vw.toolkit.utils.table.VWFieldsCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;

public class VWStepRoutingTab
extends JPanel
implements IVWPropertyTab,
TableModelListener,
ListSelectionListener,
IVWToolbarBorderActionListener,
IVWTableActionListener {
    private VWToolbarBorder m_toolbarBorder = null;
    private VWStepResponseTableModel m_tableModel = null;
    private VWTable m_responseTable = null;
    private VWRoutingPanel m_routingPanel = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private boolean m_firstTime = true;
    private boolean m_bShowResponses = true;
    private boolean m_bIsCollector = true;

    public VWStepRoutingTab(boolean bShowResponses, boolean bIsCollector) {
        this.m_bShowResponses = bShowResponses;
        this.m_bIsCollector = bIsCollector;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_firstTime && this.m_bShowResponses) {
            this.m_firstTime = false;
            if (this.m_responseTable != null) {
                this.m_responseTable.fitColumnsInTable();
            }
        }
    }

    public void init(VWAuthPropertyData authPropertyData, VWMapNode vwMapNode) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.createControls(vwMapNode);
            this.setSelectedStep(vwMapNode);
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
            if (this.m_responseTable != null) {
                this.m_responseTable.getSelectionModel().addListSelectionListener(this);
                this.m_responseTable.setRowSelectionInterval(0, 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setSelectedStep(VWMapNode vwMapNode) {
        if (this.m_responseTable != null && this.m_tableModel != null) {
            this.m_responseTable.editingStopped(new ChangeEvent(this));
            this.m_tableModel.reinitialize((VWStepDefinition)vwMapNode);
        }
        if (this.m_routingPanel != null) {
            this.m_routingPanel.setSelectedStep(vwMapNode);
        }
    }

    public void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_toolbarBorder != null) {
            this.m_toolbarBorder.removeToolbarBorderActionNotifier(this);
            this.m_toolbarBorder.releaseReferences();
            this.m_toolbarBorder = null;
        }
        if (this.m_responseTable != null) {
            this.m_responseTable.getSelectionModel().removeListSelectionListener(this);
            this.m_responseTable.removeAll();
            this.m_responseTable = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.removeTableModelListener(this);
            this.m_tableModel = null;
        }
        if (this.m_routingPanel != null) {
            this.m_routingPanel.releaseReferences();
            this.m_routingPanel = null;
        }
        this.m_authPropertyData = null;
    }

    public void tableChanged(TableModelEvent event) {
        int nRow = -1;
        switch (event.getType()) {
            case -1: {
                nRow = event.getLastRow() - 1;
                if (nRow >= 0) break;
                nRow = 0;
                break;
            }
            case 1: {
                nRow = event.getLastRow();
            }
        }
        if (this.m_responseTable != null && nRow != -1) {
            if (nRow == this.m_responseTable.getSelectedRow()) {
                this.m_responseTable.clearSelection();
            }
            this.m_responseTable.setRowSelectionInterval(nRow, nRow);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (event.getValueIsAdjusting()) {
            return;
        }
        int nRowIndex = this.m_responseTable.getSelectedRow();
        JPanel source = this.m_toolbarBorder.getClientPanel();
        if (this.m_tableModel == null || this.m_tableModel.getRowCount() - 1 == nRowIndex) {
            int nControls = 0x10000003;
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, nControls));
        } else {
            if (nRowIndex > 0) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 1));
            } else {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 1));
            }
            if (nRowIndex < this.m_tableModel.getRowCount() - 2) {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 2));
            } else {
                this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 2, 2));
            }
            this.m_toolbarBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(source, 1, 0x10000000));
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        if (this.m_responseTable != null) {
            int nRowIndex = this.m_responseTable.getSelectedRow();
            if (nRowIndex == -1) {
                return;
            }
            switch (event.getID()) {
                case 1: {
                    this.m_tableModel.moveItemUp(nRowIndex);
                    this.m_responseTable.setRowSelectionInterval(nRowIndex - 1, nRowIndex - 1);
                    break;
                }
                case 2: {
                    this.m_tableModel.moveItemDown(nRowIndex);
                    this.m_responseTable.setRowSelectionInterval(nRowIndex + 1, nRowIndex + 1);
                    break;
                }
                case 0x10000000: {
                    this.m_tableModel.deleteItem(nRowIndex);
                }
            }
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                if (this.m_responseTable == null) break;
                this.m_responseTable.stopEditing();
            }
        }
    }

    private void createControls(VWMapNode vwMapNode) {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 1;
            gbCons.weightx = 0.3;
            gbCons.weighty = 1.0;
            gbCons.anchor = 23;
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.insets = new Insets(5, 5, 5, 15);
            if (this.m_bShowResponses) {
                this.add((Component)this.getResponsesPanel(), gbCons);
                ++gbCons.gridx;
            }
            gbCons.weightx = 0.7;
            gbCons.insets = new Insets(5, 5, 5, 10);
            this.m_routingPanel = new VWRoutingPanel(this.m_bIsCollector);
            this.m_routingPanel.init(this.m_authPropertyData, vwMapNode);
            this.add((Component)this.m_routingPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private JPanel getResponsesPanel() {
        try {
            this.m_toolbarBorder = new VWToolbarBorder(VWResource.s_responsesStr, 0x10000003);
            this.m_toolbarBorder.addToolbarBorderActionNotifier(this);
            JPanel clientPanel = this.m_toolbarBorder.getClientPanel();
            clientPanel.setLayout(new BorderLayout());
            this.m_tableModel = new VWStepResponseTableModel(this.m_authPropertyData);
            this.m_tableModel.addTableModelListener(this);
            this.m_responseTable = new VWTable(this.m_tableModel);
            this.m_responseTable.getSelectionModel().addListSelectionListener(this);
            this.m_responseTable.getSelectionModel().setSelectionMode(0);
            clientPanel.add((Component)new JScrollPane(this.m_responseTable), "Center");
            for (int column = 0; column < this.m_responseTable.getColumnCount(); ++column) {
                TableColumn aColumn = this.m_responseTable.getColumnModel().getColumn(column);
                aColumn.setCellEditor(new VWFieldsCellEditor(this.m_authPropertyData.getMainContainer(), false));
                aColumn.setCellRenderer(new VWFieldsCellRenderer());
            }
            return this.m_toolbarBorder;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }
}

